#!/usr/bin/env python
# -*- coding: utf-8 -*-


class Logger(object):
    def __init__(self):
        self.subscribers = set()

    def log(self, message):
        for subscriber in self.subscribers:
            subscriber.log(message)
        print message

    def register(self, subscriber):
        self.subscribers.add(subscriber)

    def unregister(self, subscriber):
        self.subscribers.discard(subscriber)
