#!/usr/bin/env python
# -*- coding: utf-8 -*-


import led_images
import wx

LED_COLOR_RED = 1
LED_COLOR_GREEN = 2


class LED(wx.StaticBitmap):
    def __init__(self, parent, id=-1, color=LED_COLOR_GREEN):
        size = (16, 16)
        wx.StaticBitmap.__init__(self, parent, id, size=size)
        self.MinSize = size

        if color == LED_COLOR_RED:
            self.ledOn = led_images.led_red_on.GetIcon()
            self.ledOff = led_images.led_red_off.GetIcon()
        else:
            self.ledOn = led_images.led_green_on.GetIcon()
            self.ledOff = led_images.led_green_off.GetIcon()
        self._state = 0
        self.SetState(False)

    def SetState(self, state):
        self._state = state
        if state:
            self.SetIcon(self.ledOn)
        else:
            self.SetIcon(self.ledOff)

    def GetState(self):
        return self._state

    State = property(GetState, SetState)
