#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""OsTech specific Exception classes"""

class OsTechError(Exception):
    """General OsTech error"""

class OsTechCommError(OsTechError):
    """Communication errors"""

class OsTechEchoDiffersError(OsTechCommError):
    """Received echo differs from sent command."""
    def __init__(self, cmdName=None):
        self.cmdName = cmdName

    def __repr__(self):
        return "OsTechEchoDiffersError(%s)" % self.cmdName

class OsTechChecksumWrongError(OsTechCommError):
    """Checksum of read value is wrong."""

class OsTechPortInUseError(OsTechCommError):
    """A second instance using the same serial port is about to be created."""
    def __init__(self, port):
        self.port = port

    def __repr__(self):
        return "OsTechPortInUseError(%s)" % self.port

class OsTechModuleNotPresentError(OsTechError):
    """Command cannot be sent to absent module."""

