//S_.....serial routines
//DEV_...ostech routines

bool DEV_init(void)
{
    if (!DEV_print_("\r")) { // error
        goto fehler;
    }
    DEV_any_arrivals(33);
    if (!DEV_print_("\033GMS8\r")) { // Init binary mode
        goto fehler;
    }
    DEV_any_arrivals(33);
    setbc(ucDEV_Status, mDEV_t_____ok);
    return 1;
    fehler:;
    clrbc(ucDEV_Status, mDEV_t_____ok);
    return 0;
}

void DEV_done(void)
{
    DEV_print_("\033GMC8\r"); // Re-Init ASCII-Mode
    DEV_any_arrivals(11);
}

void DEV_any_arrivals(uc ucDelay)
{
    // checks for any unexpected chars
    do {
        T_waitms(ucDelay); // T_waitms -> Delay in ms 
        if (S_kpress()) S_kpgchr(); // S_kpress()-> if True, serial buffer not empty
    }                               // S_kpgchr()-> gets char from buffer
    while(S_kpress()); // any char else
    S_pufclr(); // clear buf?
}

bool DEV_print_(uc *ucS)
{
    // unformatted output of strings
    uc i; // uc-> unsigned char 
    DEV_any_arrivals(11);
    for (i=0; ucS[i]; i++) {
        if (!DEV_putchr(ucS[i])) return 0;
    }
    return 1;
}

bool DEV_printf(const uc *sss,...)
{
    // :TRUE if succesful
    // :xbc(wTStatus__, mTransNOK);
    // formated output on serial
    uc i, j, c;
    va_list vaList;
    // int nr_of_chars;
    uc buf[25]; // 25 Byte is enough
    va_start(vaList, sss); // Variable argument begin
    DEV_any_arrivals(11);
    if (!DEV_putchr(ESC)) goto fehler; // external buffer clear
    vsprintf(&buf[0], sss, vaList); // String in buffer
    i = 0;
    j = 0;
    for (; buf[i] && i < sizeof(buf); i++) {
        S_putchr(buf[i]); // send all
    }
    // i on last char
    for (; i; i--) { // check all
        c = DEV_getchr();
        if ((!c) || (c != buf[j])) goto fehler;
        j++;
    }
    va_end(vaList); // Variable argument end
    if (!DEV_putchr('\r')) goto fehler; // if all ok, <CR> at the end
    setbc(ucDEV_Status, mDEV_t_____ok); 
    return TRUE;
    fehler:;
    clrbc(ucDEV_Status, mDEV_t_____ok);
    return FALSE;
}

bool DEV_putchr(uc ucC)
{     
    S_putchr(ucC);
    if (DEV_getchr() != ucC) return 0;
    return 1;
}

uc DEV_Timeout;
uc DEV_getchr(void)
{
    DEV_Timeout = 150; // =300ms ; depending on implementation
    while (!S_kpress()) { // waiting 2 ms per character
        T_waitms(2);
        DEV_Timeout--;
        if (!DEV_Timeout) {
            clrbc(ucDEV_Status, mDEV_t_____ok); // deleting status bit
            return 0;
        }
    }
    setbc(ucDEV_Status, mDEV_t_____ok); // setting status bit
    return S_kpgchr();
}

bool DEV_recF(float *f)
{
    // receive float
    uc i;
    for (i=0; i < 5; i++) { // 4 Bytes + checksum
        DEV_buf[i] = DEV_getchr();
        if (!DEV_buf[i] && !DEV_Timeout) return FALSE;
    }
#if COMPILER==BCC
    memturn(&DEV_buf[0], 4); // turn bytes in Borland C
#endif
    // CheckSum
    i = 0x55;
    i += DEV_buf[0];
    i += DEV_buf[1];
    i += DEV_buf[2];
    i += DEV_buf[3];
    if (i == DEV_buf[4]) {
        memcpy(f, &DEV_buf[0], 4);
        return TRUE;
    }
    return FALSE;
}

bool DEV_recW(uw *u)
{
    // receive word
    uc i;
    for (i=0; i < 3; i++) { // 2 Bytes + checksum
        DEV_buf[i] = DEV_getchr();
        if (!DEV_buf[i] && !DEV_Timeout) return FALSE;
    }
#if COMPILER==BCC
    DEV_buf[4]=DEV_buf[0]; 
    DEV_buf[0]=DEV_buf[1]; 
    DEV_buf[1]=DEV_buf[4]; // turn bytes in Borland C
#endif
    // CheckSum
    i = 0x55;
    i += DEV_buf[0];
    i += DEV_buf[1];
    if (i == DEV_buf[2]) {
        memcpy(u, &DEV_buf[0], 2);
        return TRUE;
    }
    return FALSE;
}

void main(void)
{
    // Typical frame 
    while (!DEV_init()) {
        T_waitms(555);
        printf("Device Init!\r");
    }
    DEV_printf("LCT%4f", fLCT_____); // set LCT-Variable at device
    DEV_recF(&fLCT_____); // receive float
    DEV_done();
}

