#include <iostream>
#include <cstdlib>
#include "driver.h"

using namespace std;

int main(int argc, char* argv[])
{
    if (argc <= 1) {
        cout << "Usage  : example <serial device>" << endl;
        cout << "Example: example /dev/ttyS0" << endl;
        exit(1);
    }
    Serial *serial = new Serial(argv[1]);
    Driver *driver = new Driver(serial);
    bool ok;

    // GX bestimmen
    bool isExternalOn;
    cout << "External control (GX): ";
    ok = driver->sendCmd("X", "G", NULL, &isExternalOn);
    // oder auch: ok = driver->sendCmd("GX", NULL, NULL, &isExternalOn);
    if (ok) {
        cout << (isExternalOn ? "Yes" : "No");
    } else {
        cout << "ERROR";
    }
    cout << endl;

    // GTH bestimmen
    float deviceTemperature;
    cout << "Device temperature (GTH): ";
    ok = driver->sendCmd("TH", "G", NULL, &deviceTemperature);
    if (ok) {
        cout << deviceTemperature << " °C";
    } else {
        cout << "ERROR";
    }
    cout << endl;

    // Seriennummer bestimmen
    u16 serialNumber;
    cout << "Serial number (GVN): ";
    ok = driver->sendCmd("VN", "G", NULL, &serialNumber);
    if (ok) {
         cout << serialNumber;
    } else {
        cout << "ERROR";
    }
    cout << endl;

    // Lüfterspannung einstellen
    float fanVoltage = 30.0;
    cout << "Set fan voltage (GF) to " << fanVoltage << " V..." << endl;
    // Wirklich gesetzter Wert wird hier gleich zurückgelesen.
    // (Die Lüfterspannung wird vom Lasertreiber auf 24 V begrenzt.)
    ok = driver->sendCmd("F", "G", &fanVoltage, &fanVoltage);
    // oder falls der wirkliche neue Wert nicht interessiert:
    // ok = driver->sendCmd("F", "G", &fanVoltage);
    if (ok) {
        cout << "Fan voltage (GF): " << fanVoltage << " V";
    } else {
        cout << "ERROR";
    }
    cout << endl;
}
