#ifndef __SERIAL_H
#define __SERIAL_H
#include "types.h"

#ifdef __arm__
#else
#include <SerialStream.h>
#endif


class Serial {
public:
#ifdef __arm__
    Serial();
#else
    Serial(const char * const port);
#endif
    void read(char *buf, u8 length, u16 msTimeout, const char *endChar=NULL);
    void writeLine(const char *text);
    void flush(u16 msTime);
private:
#ifdef __arm__
#else
    LibSerial::SerialStream stream;
#endif
};


#endif // SERIAL_H_
