#ifndef __DRIVER_H
#define __DRIVER_H

#include "serial.h"
#include "types.h"

static const u16 msTimeout = 1000;
static const u16 msFlush = 50;

class Driver {
public:
    Driver(Serial *serial);
    void flush();
    /// Sendet Befehl zum Treiber, prüft Echo, verwirft Antwort
    /*
     * @result bei Fehler false, sonst true
     */
    bool sendCmd(const char *cmd, const char *prefix=NULL);
    bool sendCmd(const char *cmd, const char *prefix=NULL,
        const bool *value=NULL, bool *result=NULL);
    bool sendCmd(const char *cmd, const char *prefix=NULL,
        const u16 *value=NULL, u16 *result=NULL);
    bool sendCmd(const char *cmd, const char *prefix=NULL,
        const float *value=NULL, float *result=NULL);
private:
    Serial *serial;
    bool sendOnlyCmd(const char *cmd, const char *prefix=NULL);
    bool readValue(bool *value);
    bool readValue(u16 *value);
    bool readValue(float *value);
};

#endif // __DRIVER_H
